/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RootObjects
implements PropertyChangeListener {
    private ManagedObjectManager mom;
    private ArrayList rootObjects;
    private HashMap listeners;
    private Object lock = new Object();
    private Object listenerLock = new Object();
    private ObjectId myObjectId;
    private Worker worker;
    private static RootObjects instance;
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XFRMROOT";
    private static final String TRACE_MASKF = "XFRMROOF";
    private static final String TRACE_MASKD = "XFRMROOD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;

    private RootObjects() {
    }

    public static RootObjects getRootObjects() {
        if (instance == null) {
            throw new IllegalStateException("Error, the RootObjects singleton is null.");
        }
        return instance;
    }

    public ObjectId getObjectId() {
        return this.myObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRootObjectIds() {
        Trace.trace(TRACE_MASKT, "-> RootObjects.getRootObjectIds()");
        ArrayList<ObjectId> result = new ArrayList<ObjectId>();
        UserContext userContext = UserContext.getCurrentUserContext();
        Object object = this.lock;
        synchronized (object) {
            if (this.rootObjects.size() > 0) {
                Iterator iterator = this.rootObjects.iterator();
                while (iterator.hasNext()) {
                    ObjectId nextId = (ObjectId)iterator.next();
                    if (!this.mom.isObjectAllowed(nextId, userContext)) continue;
                    result.add(nextId);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- RootObjects.getRootObjectIds(), number returned is " + result.size());
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener, boolean initial) {
        Trace.trace(TRACE_MASKT, "-> RootObjects.addPropertyChangeListener()");
        UserContext userContext = UserContext.getCurrentUserContext();
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashMap();
            }
            this.listeners.put(listener, new ListenerData(listener, userContext));
        }
        if (initial) {
            List list = this.getRootObjectIds();
            PropertyChangeEvent evt = null;
            if (list.isEmpty()) {
                evt = new PropertyChangeEvent(this.myObjectId, "Root", null, null);
            } else {
                ObjectId[] ids = new ObjectId[list.size()];
                ids = list.toArray(ids);
                evt = new PropertyChangeEvent(this.myObjectId, "Root", null, ids);
            }
            listener.propertyChange(evt);
        }
        Trace.trace(TRACE_MASKT, "<- RootObjects.addPropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    private void init() {
        this.mom = ManagedObjectManager.getManagedObjectManager();
        this.rootObjects = new ArrayList();
        this.worker = new Worker(this);
        this.myObjectId = new ObjectId(this);
        ClassId[] types = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = RootObjects.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject), new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = RootObjects.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)};
        this.mom.addPropertyChangeListener((PropertyChangeListener)this, true, types);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> RootObjects.propertyChange()");
        this.worker.requestWork(evt);
        Trace.trace(TRACE_MASKT, "<- RootObjects.propertyChange()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logInfo = new FrameworkClassLogInfo(85, "RootObjects");
    }

    public static final class Init
    implements Runnable {
        public void run() {
            Trace.trace(RootObjects.TRACE_MASKT, "-> RootObjects#Init.run()");
            instance = new RootObjects();
            instance.init();
            Trace.trace(RootObjects.TRACE_MASKT, "<- RootObjects#Init.run()");
        }
    }

    class ListenerData {
        UserContext userContext;
        PropertyChangeListener listener;

        ListenerData(PropertyChangeListener listener, UserContext userContext) {
            this.listener = listener;
            this.userContext = userContext;
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread workThread;
        private RootObjects instance;

        public Worker(RootObjects instance) {
            this.instance = instance;
            this.workThread = new WorkThread("RootObjects.Worker");
            this.workThread.startWorker();
        }

        public void requestWork(PropertyChangeEvent evt) {
            this.workThread.requestWork(this, this, "ProperyChangeEvent", evt);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object performWork(Object data) throws Throwable {
            Object root;
            Trace.trace(RootObjects.TRACE_MASKT, " -> RootObjects.Worker.performWork()");
            PropertyChangeEvent evt = (PropertyChangeEvent)data;
            ArrayList<ObjectId> addedIds = new ArrayList<ObjectId>();
            ArrayList<ObjectId> removedIds = new ArrayList<ObjectId>();
            ObjectId source = (ObjectId)evt.getSource();
            Object object = RootObjects.this.lock;
            synchronized (object) {
                if (source.equals(RootObjects.this.mom.getObjectId())) {
                    int i;
                    ObjectId[] ids = (ObjectId[])evt.getOldValue();
                    if (ids == null) {
                        ids = (ObjectId[])evt.getNewValue();
                        for (i = 0; i < ids.length; ++i) {
                            RootObjects.this.mom.addPropertyChangeListener(ids[i], "Root", this.instance, false);
                            root = (Boolean)RootObjects.this.mom.getProperty(ids[i], "Root");
                            if (root == null || !((Boolean)root).booleanValue()) continue;
                            RootObjects.this.rootObjects.add(ids[i]);
                            addedIds.add(ids[i]);
                        }
                    } else {
                        for (i = 0; i < ids.length; ++i) {
                            if (!RootObjects.this.rootObjects.remove(ids[i])) continue;
                            removedIds.add(ids[i]);
                            RootObjects.this.mom.removePropertyChangeListener(ids[i], "Root", this.instance);
                        }
                    }
                } else {
                    Boolean root2 = (Boolean)evt.getNewValue();
                    if (root2.booleanValue()) {
                        RootObjects.this.rootObjects.add(source);
                        addedIds.add(source);
                    } else {
                        RootObjects.this.rootObjects.remove(source);
                        removedIds.add(source);
                    }
                }
                Trace.trace(RootObjects.TRACE_MASKF, "   there are " + RootObjects.this.rootObjects.size() + " root objects in the system user context.");
            }
            int numAdded = addedIds.size();
            int numRemoved = removedIds.size();
            if (numAdded > 0 || numRemoved > 0) {
                Collection listenersClone = null;
                root = RootObjects.this.listenerLock;
                synchronized (root) {
                    if (RootObjects.this.listeners != null) {
                        listenersClone = ((Map)RootObjects.this.listeners.clone()).values();
                    }
                }
                if (listenersClone != null) {
                    ArrayList<ObjectId> allowedIds = new ArrayList<ObjectId>();
                    ArrayList<ObjectId> idList = numAdded > 0 ? addedIds : removedIds;
                    Iterator iterator = listenersClone.iterator();
                    while (iterator.hasNext()) {
                        ListenerData listenerData = (ListenerData)iterator.next();
                        for (int i = 0; i < idList.size(); ++i) {
                            ObjectId id = (ObjectId)idList.get(i);
                            if (!RootObjects.this.mom.isObjectAllowed(id, listenerData.userContext)) continue;
                            allowedIds.add(id);
                        }
                        if (allowedIds.size() <= 0) continue;
                        PropertyChangeEvent pce = null;
                        ObjectId[] ids = new ObjectId[allowedIds.size()];
                        ids = allowedIds.toArray(ids);
                        pce = numAdded > 0 ? new PropertyChangeEvent(RootObjects.this.myObjectId, "Root", null, ids) : new PropertyChangeEvent(RootObjects.this.myObjectId, "Root", ids, null);
                        listenerData.listener.propertyChange(pce);
                        allowedIds.clear();
                    }
                }
            }
            Trace.trace(RootObjects.TRACE_MASKT, " <- RootObjects.Worker.performWork()");
            return null;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(RootObjects.TRACE_MASKT, " <> RootObjectsWorker.workCompleted()");
            if (event.hasException()) {
                event.getException().printStackTrace();
                HException hexc = new HException(event.getException());
                new FrameworkLog(logInfo, 1044, hexc).log();
            }
        }
    }
}

